clear all; close all; clc

%waste+DH load

availability=0.05; %[%] availability of heat production
Pprod=20e6/8760; %[kW] actual excess of waste heat
ratio=1*ones(12,1);
%ratio=[0.1 0.2 0.18 0.38 0.55 0.82 0.9 1 0.48 0.35 0.12 0.2];
average_monthly_waste_heat=Pprod*ratio;
% number of day in each month
days_per_month=[31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];
% initialization of the annual vector
annual_ratio=[];

for index= 1:12
    monthly_data = repmat(ratio(index), [days_per_month(index)*24, 1]);
    annual_ratio = [annual_ratio; monthly_data];
end
waste_heat_power=Pprod*annual_ratio*availability*1000;%[W] total amount of heat flux from the WIP

%load
LOAD = load('Real_load_VKBtest.txt'); 
Input = load('input.txt');
HL=LOAD(:,2)*10^3; %heating load %[W]

% load aggregation algorithm--> I have to transform the hourly load information
% into monthly load information
months_matrix=reshape(HL,[],12)';
average_month=mean(months_matrix,2);
matrix=[];
for index=1:12
    mon_data=repmat(average_month(index),[days_per_month(index)*24, 1]);
    matrix=[matrix;mon_data];
end
step_DH_load=matrix; %[W] load from the DH in a step form

%boreholes
Ny=8; % number of boreholes in Y direction
Nx=4; % number of boreholes in X direction
B=7.5; % Distanza tra i boreholes (m)
H=150;%[m]--> borehole depth
D=6;% [m]--> buried depth
rb=0.055;%[m] borehole radius
Ntot=Ny*Nx; % Number of boreholes
shank=70e-3;
kfill=0.6; %thermal conductivity of the backfilling material
pipe_do=32e-3;%[m] U-tube external diameter
ro=pipe_do/2;
tt=3e-3; %[m]--> U-tube thickness
pipe_di=pipe_do-2*tt; %[m]--> U-tube pipe internal diameter
ri=pipe_di/2;
pipe_k=0.42;%[W/mK]

%ground
kg=3.5;
ag=1*10^-6;% m^2/s thermal diffusivity of the ground

%heat carrier fluid
cpw=4186;%[J/kgK]
rhow=1000;%[kg/m^3]
%evaluation of the equivalent diameter for U-tube pipes
req=(0.414*ro)+(0.5*shank);
Rbeff=abs(1/(2*pi*kfill)*log((rb/req)*sqrt(req/shank/2)));

% Time discretization (e.g., hourly for one charging season)
days = 365; 
time = 1:1:days*24;
n=length(time);
 
%% BOREHOLE CONFIGURATION
% Calcola la coordinata X e Y di ciascun borehole
x = 0:B:(Nx-1)*B;
y = 0:B:(Ny-1)*B;

[X, Y] = meshgrid(x, y);

C1 = [];
C2 = [];
d = 0;

%field model
for i = 1:Ny
    for j = 1:Nx
        for z = 1:Ny
            for k = 1:Nx
                if i == z && j == k
                    d = rb^2;
                else
                    d = (X(i, j) - X(z, k))^2 + (Y(i, j) - Y(z, k))^2;
                end
                index = find(C2 == d);
                if isempty(index)
                    C2 = [C2, d];
                    C1 = [C1, 1];
                else
                    C1(index) =  C1(index) + 1;
                end
            end
        end
    end
end

ierf = @(x) (x .* erf(x)) - (1 / sqrt(pi) * (1 - exp(-x.^2)));
hc = @(s) H*s; 
dc = @(s) D*s; 
Ie = @(s) sum(C1 .* exp(-C2 .* s.^2)) / (Nx * Ny);
ILS = @(hc, dc) 2 * ierf(hc) + 2 * ierf(hc + (2 * dc)) - ierf((2 * hc) + (2 * dc)) - ierf(2 * dc);
intfunc = @(s) Ie(s) .* ILS(hc(s), dc(s)) / (H.*(s.^2));

%% INTIALIZATION 

%Tb=zeros(n,1);
Tf=zeros(n,1);
ground_flux=zeros(n,1);
surplus=zeros(n,1);
max_flux=30;
min_flux=-30;
T_gr = 8;
T_supp=60;
T_ret=25;
Tin_BTES=90*ones(n,1);
Tout_BTES=zeros(n,1);
mdot_WASTE=zeros(n,1);
Tout_WASTE=95*ones(n,1);
Tin_WASTE=50*ones(n,1);
Tapp=5;
mdot_BTES=zeros(n,1);
mdot_WASTE=zeros(n,1);


%% HEAT PUMP MODEL
% Loading heat pump model coefficients
Condenser_Coefficients = load('Condenser_capacity.txt');
Evaporator_Coefficients = load('Evaporator_capacity.txt');
Compressor_Coefficients = load('Compressor_capacity.txt');
CondenserTemperature_Coefficients = load('Condenser_temperature.txt');

% Heat pump selection
index = 6; % *** Enter the index of chosen compressor model from Heatpump_info.txt *** % index = 6 for Load 1, index = 10 for Load 2
q = 1*Evaporator_Coefficients(index,:);% Function coefficients for the evaporator model
C = 1*Condenser_Coefficients(index,:); % Function coefficients for the condenser model 
P = 1*Compressor_Coefficients(index,:); % Function coefficients for the compressor model
g = 1*CondenserTemperature_Coefficients(index,:); %function coefficients for the condensing temperature

%% STORAGE OPERATION
power_waste = 1*10^5; %W

surplus = waste_heat_power - step_DH_load; 
qg_charge = 40;
qg_dis = - 30;

deficit = surplus;
for it = 1:8760
    if deficit(it)<0
        deficit(it) = -deficit(it);
    else 
        deficit(it) = 0;
    end
end

char=surplus;

for it = 1:8760
    if char(it)>0
        char(it) = char(it);
    else 
        char(it) = 0;
    end
end


def_en = sum(deficit)/10^6; %MWh

qg=surplus/Ntot/H; %just in charging mode
% DISCHARGE
for t = 1:90*24
        ground_flux(t) = qg_dis;
        Qborehole(t) =Ntot* ground_flux(t) * H;
        deltaT(t) = (ground_flux(t) / (4 * pi * kg) * integral(intfunc, 1 / sqrt(4 * ag * time(t)), inf, 'ArrayValued', true));

        Rtot(t) = Rbeff+(deltaT(t)./ground_flux(t));
        Tb(t) = T_gr + deltaT(t);
        Tf(t) = Tb(t)+(Rtot(t)*ground_flux(t));

        % HEX1
        Tin_WASTE(t)=T_ret+Tapp;
        mdot_WASTE(t)=waste_heat_power(t)./(cpw*(Tout_WASTE(t)-Tin_WASTE(t)));
        QHEX1(t)=mdot_WASTE(t)*cpw*(Tout_WASTE(t)-Tin_WASTE(t));
        mdot_1_dis(t)=QHEX1(1)/(cpw*(T_supp-T_ret));

        %DH+right side of the HP
        mdot_DH(t)=HL(t)/(cpw*(T_supp-T_ret));
        mdot_HP(t)=abs(mdot_DH(t)-mdot_1_dis(t)); %ci sono alcuni valori negativi perché a volte il carico è nullo

        %HP model
        To=0;
        delta_Tev = 5; % K assumed and can be changed
        delta_Tcd = 5; % K assumed and can be changed
        Td = 65; % discharge temperature of the compressor
        % evaporator capacity function
        Qcl_0 = q(1) + q(2).*To + q(3).*To.^2 + q(4).*To.^3 + q(5).*Td.^3 + q(6).*Td + q(7).*Td.*To + q(8).*Td.*To.^2; 
        % Condenser capacity function
        Qcd_0 = C(1) + C(2).*Td + C(3).*To + C(4).*Qcl_0 + C(5).*Td.*To + C(6).*Qcl_0.*Td + C(7).*To.^2 + C(8).*Qcl_0.*To;
        % Compressor power function
        Pcom_0 = P(1) + P(2).*To + P(3).*Td + P(4).*Qcl_0.*Td + P(5).*To.^2 + P(6).*Td.*Qcl_0.^2 + P(7).*Qcl_0 + P(8).*To.*Qcl_0.^2;
        % Condensation temperature function
        Tc = g(1).*Td + g(2).*To + g(3).*To.^2 + g(4) + g(5).*Td.*To + g(6).*To.^3 + g(7).*Td.^2 + g(8).*Td.*To.^2; 

        

        %supply and return pipe
%         Tout_COND=T_supp;
%         Tin_COND=T_ret;
%         Td=Tout_COND-delta_Tcd;
%         Qcl_0=mdot_HP(t)*cpw*(Tout_COND-Tin_COND);
        
%         Qcl_0=q(1) + q(2).*To + q(3).*To.^2 + q(4).*To.^3 + q(5).*Td.^3 + q(6).*Td + q(7).*Td.*To + q(8).*Td.*To.^2;
%         Tin_BTES(t)=To+delta_Tev;
%         mdot_BTES(t)=(ground_flux(t)*H)./(2*cpw*(Tin_BTES(t)-Tf(t)));
%         mdot_BTES_tot(t)=Ntot*mdot_BTES(t);
%         Tout_BTES(t)=Tin_BTES(t)+(Qborehole(t)/mdot_BTES_tot(t)/cpw);
%         Qcd_0=mdot_BTES_tot(t)*cpw*(Tout_BTES(t)-Tin_BTES(t));
%         Tin_BTES(t)=Tout_BTES(t)-(Qborehole(t)/mdot_BTES_tot(t)/cpw);
%         To=Tin_BTES(t)-delta_Tev;
end

T_gr = Tb(end);

% CHARGING SEASON
for t = 90*24+1: 304*24
        ground_flux(t) = qg_charge;
        Qborehole(t) =Ntot*ground_flux(t) * H;
        
        deltaT(t) = (ground_flux(t) / (4 * pi * kg) * integral(intfunc, 1 / sqrt(4 * ag * time(t-90*24)), inf, 'ArrayValued', true));
        Rtot(t) =Rbeff+(deltaT(t)/ground_flux(t));
        Tb(t) = T_gr + deltaT(t);
        Tf(t) = Tb(t)+(Rtot(t)*ground_flux(t));
        mdot_BTES(t)=(ground_flux(t)*H)./(2*cpw*(Tin_BTES(t)-Tf(t)));

        mdot_BTES_tot(t)=Ntot*mdot_BTES(t);
        Tout_BTES(t)=Tin_BTES(t)-(Qborehole(t)/mdot_BTES_tot(t)/cpw);
        %waste incineration plant+DH
        mdot_WASTE(t)=waste_heat_power(t)./(cpw*(Tout_WASTE(t)-Tin_WASTE(t)));
        mdot_DH(t)=HL(t)/(cpw*(T_supp-T_ret));

        %HEX1 
        T1=T_ret+Tapp;
        mdot_1(t)=mdot_DH(t).*((T_supp-T_ret)./(Tout_WASTE(t)-T1));
        QHEX1(t)=mdot_1(t).*cpw.*(Tout_WASTE(t)-T1);

        %HEX2
        T2(t)=Tout_BTES(t)+Tapp;
        mdot_2(t)=mdot_WASTE(t)-mdot_1(t);
%         Tin_BTES(t)=Tout_BTES(t)+((Tout_WASTE(t)-T2(t))*mdot_2(t)./(mdot_BTES_tot(t)));
%         mdot_BTES_tot(t)=(Qborehole(t))./(2*cpw*(Tin_BTES(t)-Tf(t)));
%         Tout_BTES(t)=Tin_BTES(t)-(Qborehole(t)/mdot_BTES_tot(t)/cpw);
        Tin_WASTE(t)=(mdot_2(t)*T2(t)+mdot_1(t)*T1)./mdot_WASTE(t);
end       

T_gr = Tb(end);
% DISCHARGE
for t = 304*24 + 1 : 8760
        ground_flux(t) = qg_dis;
        Qborehole(t) =Ntot* ground_flux(t) * H;
        deltaT(t) = (ground_flux(t) / (4 * pi * kg) * integral(intfunc, 1 / sqrt(4 * ag * time(t-304*24)), inf, 'ArrayValued', true));
        Rtot(t) = Rbeff+(deltaT(t)./ground_flux(t));
        Tb(t) = T_gr + deltaT(t);
        Tf(t) = Tb(t)+(Rtot(t)*ground_flux(t));

        % HEX1
        Tin_WASTE(t)=T_ret+Tapp;
        mdot_WASTE(t)=waste_heat_power(t)./(cpw*(Tout_WASTE(t)-Tin_WASTE(t)));
        QHEX1(t)=mdot_WASTE(t)*cpw*(Tout_WASTE(t)-Tin_WASTE(t));
        mdot_1_dis(t)=QHEX1(1)/(cpw*(T_supp-T_ret));

        %DH+right side of the HP
        mdot_DH(t)=HL(t)/(cpw*(T_supp-T_ret));
        mdot_HP(t)=abs(mdot_DH(t)-mdot_1_dis(t)); %ci sono alcuni valori negativi perché a volte il carico è nullo

        %HP model
        To=0;
        delta_Tev = 5; % K assumed and can be changed
        delta_Tcd = 5; % K assumed and can be changed
        Td = 65; % discharge temperature of the compressor
        % evaporator capacity function
        Qcl_0 = q(1) + q(2).*To + q(3).*To.^2 + q(4).*To.^3 + q(5).*Td.^3 + q(6).*Td + q(7).*Td.*To + q(8).*Td.*To.^2; 
        % Condenser capacity function
        Qcd_0 = C(1) + C(2).*Td + C(3).*To + C(4).*Qcl_0 + C(5).*Td.*To + C(6).*Qcl_0.*Td + C(7).*To.^2 + C(8).*Qcl_0.*To;
        % Compressor power function
        Pcom_0 = P(1) + P(2).*To + P(3).*Td + P(4).*Qcl_0.*Td + P(5).*To.^2 + P(6).*Td.*Qcl_0.^2 + P(7).*Qcl_0 + P(8).*To.*Qcl_0.^2;
        % Condensation temperature function
        Tc = g(1).*Td + g(2).*To + g(3).*To.^2 + g(4) + g(5).*Td.*To + g(6).*To.^3 + g(7).*Td.^2 + g(8).*Td.*To.^2; 

        %supply and return pipe
%         Tout_COND=T_supp;
%         Tin_COND=T_ret;
%         Td=Tout_COND-delta_Tcd;
%         Qcl_0=mdot_HP(t)*cpw*(Tout_COND-Tin_COND);
        
%         Qcl_0=q(1) + q(2).*To + q(3).*To.^2 + q(4).*To.^3 + q(5).*Td.^3 + q(6).*Td + q(7).*Td.*To + q(8).*Td.*To.^2;
%         Tin_BTES(t)=To+delta_Tev;
%         mdot_BTES(t)=(ground_flux(t)*H)./(2*cpw*(Tin_BTES(t)-Tf(t)));
%         mdot_BTES_tot(t)=Ntot*mdot_BTES(t);
%         Tout_BTES(t)=Tin_BTES(t)+(Qborehole(t)/mdot_BTES_tot(t)/cpw);
%         Qcd_0=mdot_BTES_tot(t)*cpw*(Tout_BTES(t)-Tin_BTES(t));
%         Tin_BTES(t)=Tout_BTES(t)-(Qborehole(t)/mdot_BTES_tot(t)/cpw);
%         To=Tin_BTES(t)-delta_Tev;
end
          

figure(1)
plot(time,Tb,'linewidth',2)
grid on
xlabel('Time [h]')
ylabel('Temperature [°C]')
title('Average borehole wall temperature in 1 year')
set(gca,'fontsize',16)

figure(2)
plot(time,HL*10^-3,'r','linewidth',0.5)
grid on
hold on
plot(time,waste_heat_power*10^-3,'b','linewidth',2)
xlabel('Time [h]')
ylabel('Power [kW]')
set(gca,'fontsize',16)

figure(3)
plot(time,Tb,'linewidth',2)
hold on
plot(time,Tin_BTES,'linewidth',2)
hold on
plot(time,Tout_BTES,'linewidth',2)
grid on
xlabel('Time [h]')
ylabel('Temperature [°C]')
legend('Borehole wall average temperature','Inlet fluid temperature','Outlet fluid temperature','location','se')
set(gca,'fontsize',16)

figure(4)
plot(time,waste_heat_power*10^-3,'linewidth',2)
hold on
plot(time,step_DH_load*10^-3,'linewidth',2)
xlabel('Time [h]')
ylabel('Power [kW]')
legend('Power available from WIP','Average annual load from DH','location','best')
set(gca,'fontsize',16)

figure(5)
plot(time,surplus*10^-3,'linewidth',2)
xlabel('Time [h]')
ylabel('Power [kW]')
title('Surplus between WIP and DH load')
set(gca,'fontsize',16)

figure(6)
bar(deficit) %not covered by WIP
hold on
bar(char)

% capacità dello storage: max del deficit
% assicurare che sia maggiore o uguale di quello che succede durante la
% fase di carica

